package ru.yandex.direct.ytcomponents.repository;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

import org.jooq.impl.TableImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytwrapper.dynamic.TableMappings;
import ru.yandex.direct.ytwrapper.model.YtOperator;
import ru.yandex.direct.ytwrapper.model.YtTable;

@Component
public class StatsDynClusterFreshnessRepository {
    public static final String LAST_SYNC_TIME_ATTR = "last_sync_time_bs-chevent-log";

    private final TableMappings tableMappings;

    @Autowired
    public StatsDynClusterFreshnessRepository(TableMappings tableMappings) {
        this.tableMappings = tableMappings;
    }

    public ZonedDateTime getClusterFreshnessTimeForTable(YtOperator ytOperator, TableImpl table) {
        String statTablePath = tableMappings.getTableMappings().get(table);

        return getClusterFreshnessTimeForTable(ytOperator, statTablePath);
    }

    public ZonedDateTime getClusterFreshnessTimeForTable(YtOperator ytOperator, String tablePath) {

        String lastSyncTimeStr =
                ytOperator.readTableStringAttribute(new YtTable(tablePath), LAST_SYNC_TIME_ATTR);

        // Время хранится в ISO-формате с time zone
        return ZonedDateTime.parse(lastSyncTimeStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}
