package ru.yandex.direct.ytcomponents.service

import org.springframework.stereotype.Component
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterFreshness
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterWeightFunction

/**
 * Временный провайдер для тестирования [DIRECT-172608](https://st.yandex-team.ru/DIRECT-172608)
 */
@Component
class ActStatDynContextProvider(
    directYtDynamicConfig: DirectYtDynamicConfig,
    ytProvider: YtProvider,
    ytDynamicConfig: YtDynamicConfig,
) : BaseDynContextProvider(
    directYtDynamicConfig, ytProvider,
    { ClusterWeightFunction { ClusterFreshness.FRESH } },
    { it.actStatYtClusters },
    ytDynamicConfig.defaultSelectRowsTimeout()
)
