package ru.yandex.direct.ytcomponents.service;

import org.jooq.impl.TableImpl;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

public class BaseCommunicationConfigDynContextProvider extends BaseDynContextProvider {

    private final YtProvider ytProvider;
    private final YtCluster writeYtCluster;
    private final String configurationTablePath;

    public BaseCommunicationConfigDynContextProvider(
            YtDynamicConfig ytDynamicConfig,
            DirectYtDynamicConfig directYtDynamicConfig,
            TableAvailabilityChecker tableAvailabilityChecker,
            YtProvider ytProvider,
            TableImpl table,
            String tablePath) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider, table),
                c -> directYtDynamicConfig.tables().communicationPlatform().readConfigClusters(),
                ytDynamicConfig.defaultSelectRowsTimeout());
        this.ytProvider = ytProvider;
        this.writeYtCluster = directYtDynamicConfig.tables().communicationPlatform().writeConfigCluster();
        this.configurationTablePath = tablePath;
    }

    public YtDynamicOperator getYtWriteOperator() {
        return ytProvider.getDynamicOperator(writeYtCluster);
    }

    public String getYtConfigurationTablePath() {
        return configurationTablePath;
    }
}
