package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;
import java.util.Collection;
import java.util.Timer;
import java.util.function.Function;
import java.util.function.Supplier;

import javax.annotation.PreDestroy;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterWeightFunction;
import ru.yandex.direct.ytwrapper.dynamic.selector.FreshnessAndHashBasedClusterChooser;
import ru.yandex.direct.ytwrapper.model.YtCluster;

public abstract class BaseDynContextProvider {

    private final Timer timer;
    private final YtDynamicContextProvider ytDynamicContextProvider;

    public BaseDynContextProvider(DirectYtDynamicConfig ytDynamicConfig,
                                  YtProvider ytProvider,
                                  Supplier<ClusterWeightFunction> clusterWeightFunctionSupplier,
                                  Duration timeout) {
        this(ytDynamicConfig, ytProvider, clusterWeightFunctionSupplier, DirectYtDynamicConfig::getStatClusters,
                timeout);
    }

    public BaseDynContextProvider(DirectYtDynamicConfig ytDynamicConfig,
                                  YtProvider ytProvider,
                                  Supplier<ClusterWeightFunction> clusterWeightFunctionSupplier,
                                  Function<DirectYtDynamicConfig, Collection<YtCluster>> clustersSupplier,
                                  Duration timeout) {

        this.timer = new Timer(getClass().getSimpleName() + "-Timer", true);

        ClusterWeightFunction clusterWeightFunction = clusterWeightFunctionSupplier.get();
        FreshnessAndHashBasedClusterChooser clusterChooser = new FreshnessAndHashBasedClusterChooser(timer,
                ytDynamicConfig.getClusterRefreshPeriod(),
                clustersSupplier.apply(ytDynamicConfig),
                clusterWeightFunction);
        ytDynamicContextProvider = new YtDynamicContextProvider<>(clusterChooser, ytProvider, timeout);
    }

    @PreDestroy
    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public YtDynamicContext getContext() {
        return ytDynamicContextProvider.getContext();
    }
}
