package ru.yandex.direct.ytcomponents.service

import org.springframework.stereotype.Component
import ru.yandex.direct.grid.schema.yt.Tables
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker

@Component
class BlrtDynContextProvider(
    directYtDynamicConfig: DirectYtDynamicConfig,
    ytProvider: YtProvider,
    tableAvailabilityChecker: TableAvailabilityChecker,
    ytDynamicConfig: YtDynamicConfig,
) : BaseDynContextProvider(
    directYtDynamicConfig, ytProvider,
    { QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider, Tables.FEED_TO_TASKS_DYN) },
    { it.blrtClusters },
    ytDynamicConfig.defaultSelectRowsTimeout()
)
