package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;
import java.util.Timer;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser;
import ru.yandex.inside.yt.kosher.cypress.YPath;

import static ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR;

@Component
@ParametersAreNonnullByDefault
public class BrandSafetyStatsDynContextProvider {
    private static final Duration CLUSTER_REFRESH_INTERVAL = Duration.ofMinutes(1);
    private static final Duration SELECT_ROWS_TIMEOUT = Duration.ofMinutes(1);

    private final Timer timer;
    private final YtDynamicContextProvider ytDynamicContextProvider;

    public BrandSafetyStatsDynContextProvider(DirectYtDynamicConfig config, YtProvider ytProvider) {

        this.timer = new Timer(getClass().getSimpleName() + "-Timer", true);

        AttributeBasedClusterChooser clusterChooser = new AttributeBasedClusterChooser(
                timer,
                CLUSTER_REFRESH_INTERVAL,
                ytProvider,
                config.getStatClusters(),
                YPath.simple(config.tables().yabsStat().brandSafetyStatTablePath()), "@modification_time",
                REVERSED_INSTANT_COMPARATOR);

        ytDynamicContextProvider = new YtDynamicContextProvider<>(clusterChooser, ytProvider, SELECT_ROWS_TIMEOUT);
    }

    @PreDestroy
    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public YtDynamicContext getContext() {
        return ytDynamicContextProvider.getContext();
    }
}
