package ru.yandex.direct.ytcomponents.service;

import java.util.Timer;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.BrandSurveyStatusDynConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser;
import ru.yandex.inside.yt.kosher.cypress.YPath;

import static ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR;

@Component
@ParametersAreNonnullByDefault
public class BrandSurveyStatusDynContextProvider {
    private final Timer timer;
    private final YtDynamicContextProvider ytDynamicContextProvider;

    public BrandSurveyStatusDynContextProvider(
            BrandSurveyStatusDynConfig config, YtProvider ytProvider) {

        this.timer = new Timer(getClass().getSimpleName() + "-Timer", true);

        AttributeBasedClusterChooser clusterChooser = new AttributeBasedClusterChooser(
                timer,
                config.getClusterRefreshInterval(),
                ytProvider,
                config.getClusters(),
                YPath.simple(config.getBrandSurveyStatusTablePath()), "@modification_time",
                REVERSED_INSTANT_COMPARATOR);

        ytDynamicContextProvider = new YtDynamicContextProvider<>(
                clusterChooser, ytProvider, config.getSelectRowsTimeout());
    }

    @PreDestroy
    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public YtDynamicContext getContext() {
        return ytDynamicContextProvider.getContext();
    }
}
