package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.EXTERNAL_CALLTRACKING_BY_DOMAIN;

@Component
public class CalltrackingExternalByDomainDynContextProvider extends BaseDynContextProvider {

    public CalltrackingExternalByDomainDynContextProvider(
            DirectYtDynamicConfig directYtDynamicConfig,
            YtProvider ytProvider,
            TableAvailabilityChecker tableAvailabilityChecker,
            YtDynamicConfig ytDynamicConfig
    ) {
        super(
                directYtDynamicConfig,
                ytProvider,
                () -> new QueryBasedClusterWeightFunction(
                        tableAvailabilityChecker,
                        ytProvider,
                        EXTERNAL_CALLTRACKING_BY_DOMAIN
                ),
                DirectYtDynamicConfig::getCalltrackingExternalByDomainsClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
