package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.CALLTRACKING_PHONE_WITHOUT_REPLACEMENTS;

@Component
public class CalltrackingNumbersWithoutChangesDynContextProvider extends BaseDynContextProvider {

    public CalltrackingNumbersWithoutChangesDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig,
                                                               YtProvider ytProvider,
                                                               TableAvailabilityChecker tableAvailabilityChecker,
                                                               YtDynamicConfig ytDynamicConfig) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        CALLTRACKING_PHONE_WITHOUT_REPLACEMENTS),
                DirectYtDynamicConfig::getCalltrackingPhonsWithoutReplacementsClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
