package ru.yandex.direct.ytcomponents.service

import org.springframework.stereotype.Component
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtOperator
import ru.yandex.inside.yt.kosher.cypress.YPath
import java.time.Duration
import java.util.*
import javax.annotation.PreDestroy

@Component
class CampaignGridStatContextProvider(
        ytDynamicConfig: YtDynamicConfig,
        config: DirectYtDynamicConfig,
        private val ytProvider: YtProvider
) {
    companion object {
        private const val FRESHNESS_ATTRIBUTE = "@last_sync_time"
        private val TIMEOUT = Duration.ofSeconds(5)
    }

    private val timer: Timer = Timer(javaClass.simpleName + "-Timer", true)
    private val attributeBasedClusterChooser = AttributeBasedClusterChooser(
            timer,
            TIMEOUT,
            ytProvider,
            config.statClusters,
            YPath.simple(config.tables().yabsStat().orderStatTablePath()),
            FRESHNESS_ATTRIBUTE,
            AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR)
    private val ytDynamicContextProvider: YtDynamicContextProvider<*> = YtDynamicContextProvider(
            attributeBasedClusterChooser,
            ytProvider,
            ytDynamicConfig.defaultSelectRowsTimeout())

    @PreDestroy
    fun stopTimer() {
        timer.cancel()
    }

    fun getContext(): YtDynamicContext {
        return ytDynamicContextProvider.context
    }

    fun getOperator(): YtOperator {
        return ytProvider.getOperator(attributeBasedClusterChooser.cluster
                .orElseThrow { IllegalStateException("No clusters available") })
    }

}