package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.grid.schema.yt.Tables;
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

@Component
public class CommunicationChannelDynContextProvider extends BaseDynContextProvider {

    public CommunicationChannelDynContextProvider(
            YtDynamicConfig ytDynamicConfig,
            DirectYtDynamicConfig directYtDynamicConfig,
            TableAvailabilityChecker tableAvailabilityChecker,
            YtProvider ytProvider) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        Tables.COMMUNICATIONSCHANNEL),
                DirectYtDynamicConfig::getCommunicationPlatformClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
