package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;
import java.util.Timer;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser;
import ru.yandex.inside.yt.kosher.cypress.YPath;

import static ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR;

@Component
@ParametersAreNonnullByDefault
public class ConversionPriceForecastDynContextProvider {
    private final Timer timer;
    private final YtDynamicContextProvider ytDynamicContextProvider;

    private static final Duration CLUSTER_REFRESH_INTERVAL = Duration.ofMinutes(1);

    @Autowired
    public ConversionPriceForecastDynContextProvider(DirectYtDynamicConfig config, YtProvider ytProvider,
                                                     YtDynamicConfig ytDynamicConfig) {

        this.timer = new Timer(getClass().getSimpleName() + "-Timer", true);

        AttributeBasedClusterChooser clusterChooser = new AttributeBasedClusterChooser(
                timer,
                CLUSTER_REFRESH_INTERVAL,
                ytProvider,
                config.getSuggestConversionPriceClusters(),
                YPath.simple(config.tables().direct().suggestConversionPriceTablePath()),
                "@modification_time",
                REVERSED_INSTANT_COMPARATOR);

        ytDynamicContextProvider = new YtDynamicContextProvider<>(
                clusterChooser, ytProvider, ytDynamicConfig.defaultSelectRowsTimeout());
    }

    @PreDestroy
    public void stopTimer() {
        timer.cancel();
    }

    public YtDynamicContext getContext() {
        return ytDynamicContextProvider.getContext();
    }

}
