package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;
import java.time.ZonedDateTime;

import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytcomponents.repository.ConversionStatsDynClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterFreshness;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtOperator;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.tables.DirectconversioncostBs.DIRECTCONVERSIONCOST_BS;

@Component
public class ConversionsStatsDynContextProvider extends BaseDynContextProvider {
    public ConversionsStatsDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig, YtProvider ytProvider,
                                              TableAvailabilityChecker tableAvailabilityChecker,
                                              ConversionStatsDynClusterFreshnessRepository conversionStatsDynClusterFreshnessRepository,
                                              YtDynamicConfig ytDynamicConfig) {
        super(directYtDynamicConfig,
                ytProvider,
                () -> new StatClusterWeightFunc(tableAvailabilityChecker, conversionStatsDynClusterFreshnessRepository,
                        ytProvider, DIRECTCONVERSIONCOST_BS),
                ytDynamicConfig.defaultSelectRowsTimeout());
    }

    private static class StatClusterWeightFunc extends QueryBasedClusterWeightFunction {
        private final ConversionStatsDynClusterFreshnessRepository conversionStatsDynClusterFreshnessRepository;
        private static final Duration FRESH_DELAY = Duration.ofMinutes(60);

        private StatClusterWeightFunc(TableAvailabilityChecker tableAvailabilityChecker,
                                      ConversionStatsDynClusterFreshnessRepository conversionStatsDynClusterFreshnessRepository,
                                      YtProvider ytProvider, TableImpl<?> table) {
            super(tableAvailabilityChecker, ytProvider, table);
            this.conversionStatsDynClusterFreshnessRepository = conversionStatsDynClusterFreshnessRepository;
        }

        @Override
        protected ClusterFreshness calcFreshness(YtCluster ytCluster) {
            YtOperator ytOperator = ytProvider.getOperator(ytCluster);
            ZonedDateTime lastSyncTime =
                    conversionStatsDynClusterFreshnessRepository.getClusterFreshnessTimeForTable(ytOperator, table);

            ZonedDateTime now = ZonedDateTime.now();
            if (lastSyncTime.compareTo(now.minus(FRESH_DELAY)) > 0) {
                return ClusterFreshness.FRESH;
            } else {
                return ClusterFreshness.ROTTEN;
            }
        }
    }
}
