package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.COUNTER_BY_DOMAIN;

@Component
public class CounterByDomainDynContextProvider extends BaseDynContextProvider {

    public CounterByDomainDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig,
                                             YtProvider ytProvider,
                                             TableAvailabilityChecker tableAvailabilityChecker,
                                             YtDynamicConfig ytDynamicConfig) {

        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        COUNTER_BY_DOMAIN),
                DirectYtDynamicConfig::getCounterByDomainClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
