package ru.yandex.direct.ytcomponents.service;

import java.util.Timer;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser;
import ru.yandex.inside.yt.kosher.cypress.YPath;

import static ru.yandex.direct.ytcomponents.repository.StatsDynClusterFreshnessRepository.LAST_SYNC_TIME_ATTR;
import static ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR;


/**
 * Определяет контекст запроса на основе свежести таблицы //home/yabs/stat/DirectGridStat
 */
@Component
public class DirectGridStatDynContextProvider implements AutoCloseable {
    private final Timer timer;
    private final YtDynamicContextProvider<Void> ytDynamicContextProvider;


    public DirectGridStatDynContextProvider(
            DirectYtDynamicConfig directYtDynamicConfig, YtProvider ytProvider,
            YtDynamicConfig ytDynamicConfig) {
        this.timer = new Timer(getClass().getSimpleName() + "-Timer", true);
        var attributeBasedClusterChooser = new AttributeBasedClusterChooser(timer,
                directYtDynamicConfig.getClusterRefreshPeriod(), ytProvider,
                directYtDynamicConfig.getStatClusters(),
                YPath.simple(directYtDynamicConfig.tables().yabsStat().ordersTablePath()),
                LAST_SYNC_TIME_ATTR, REVERSED_INSTANT_COMPARATOR);
        ytDynamicContextProvider = new YtDynamicContextProvider<>(attributeBasedClusterChooser, ytProvider,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }


    public YtDynamicContext getContext() {
        return ytDynamicContextProvider.getContext();
    }

    @Override
    public void close() {
        if (timer != null) {
            timer.cancel();
        }
    }
}
