package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.CONV_MAIN_AD_GOALS;

@Component
public class MetrikaConversionAdGoalsDynContextProvider extends BaseDynContextProvider {

    public MetrikaConversionAdGoalsDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig,
                                                      YtProvider ytProvider,
                                                      TableAvailabilityChecker tableAvailabilityChecker,
                                                      YtDynamicConfig ytDynamicConfig) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        CONV_MAIN_AD_GOALS),
                DirectYtDynamicConfig::getMetrikaConvAdGoalsClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
