package ru.yandex.direct.ytcomponents.service

import org.springframework.stereotype.Component
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser
import ru.yandex.direct.ytwrapper.dynamic.selector.AttributeBasedClusterChooser.REVERSED_INSTANT_COMPARATOR
import ru.yandex.inside.yt.kosher.cypress.YPath
import java.util.*
import javax.annotation.PreDestroy

@Component
class MobileAppStatDynContextProvider(
    ytDynamicConfig: YtDynamicConfig,
    config: DirectYtDynamicConfig,
    ytProvider: YtProvider,
) {
    companion object {
        private const val FRESHNESS_ATTRIBUTE = "@last_sync_time"
    }

    private val timer: Timer = Timer(javaClass.simpleName + "-Timer", true)
    private val attributeBasedClusterChooser = AttributeBasedClusterChooser(
        timer,
        config.clusterRefreshPeriod,
        ytProvider,
        config.mobileAppStatClusters,
        YPath.simple(config.tables().yabsStat().mobileAppStatTablePath()),
        FRESHNESS_ATTRIBUTE,
        REVERSED_INSTANT_COMPARATOR)
    private val ytDynamicContextProvider: YtDynamicContextProvider<*> = YtDynamicContextProvider(
        attributeBasedClusterChooser,
        ytProvider,
        ytDynamicConfig.defaultSelectRowsTimeout())

    @PreDestroy
    fun stopTimer() {
        timer.cancel()
    }

    fun getContext(): YtDynamicContext {
        return ytDynamicContextProvider.context
    }
}
