package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytcomponents.repository.StatsDynClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.tables.OrderstatdayBs.ORDERSTATDAY_BS;

@Component
public class OrderStatDayDynContextProvider extends StatsDynContextProvider {
    // таймаут на запрос в динамическую таблицу
    private static final Duration TIMEOUT = Duration.ofSeconds(5);

    @Autowired
    public OrderStatDayDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig, YtProvider ytProvider,
                                          TableAvailabilityChecker tableAvailabilityChecker,
                                          StatsDynClusterFreshnessRepository statsDynClusterFreshnessRepository) {
        super(directYtDynamicConfig, ytProvider, tableAvailabilityChecker, statsDynClusterFreshnessRepository,
                ORDERSTATDAY_BS, TIMEOUT);
    }
}
