package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytcomponents.repository.StatsDynClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.tables.OrderstatfraudBs.ORDERSTATFRAUD_BS;

@Component
public class OrderStatFraudDynContextProvider extends StatsDynContextProvider {
    // таймаут на запрос в динамическую таблицу
    public static final Duration TIMEOUT = Duration.ofSeconds(5);

    public OrderStatFraudDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig, YtProvider ytProvider,
                                            TableAvailabilityChecker tableAvailabilityChecker,
                                            StatsDynClusterFreshnessRepository statsDynClusterFreshnessRepository) {
        super(directYtDynamicConfig, ytProvider, tableAvailabilityChecker, statsDynClusterFreshnessRepository,
                ORDERSTATFRAUD_BS, TIMEOUT);
    }

}

