package ru.yandex.direct.ytcomponents.service;

import java.time.Duration;
import java.util.List;
import java.util.Timer;

import javax.annotation.PreDestroy;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContext;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.dynamic.selector.WeightBasedClusterChooser;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.PHRASEIDBYDATAMD5_BS;

@Component
public class PhraseIdByDataMd5DynContextProvider {
    private static final Duration SELECT_TIMEOUT = Duration.ofSeconds(5);
    private final WeightBasedClusterChooser clusterChooser;
    private final Timer timer;
    private final YtProvider ytProvider;

    public PhraseIdByDataMd5DynContextProvider(DirectYtDynamicConfig ytDynamicConfig,
                                               YtProvider ytProvider,
                                               TableAvailabilityChecker tableAvailabilityChecker) {
        this.ytProvider = ytProvider;

        timer = new Timer(getClass().getSimpleName() + "-Timer", true);
        clusterChooser = new WeightBasedClusterChooser(timer,
                ytDynamicConfig.getClusterRefreshPeriod(),
                ytDynamicConfig.getPhraseMd5Clusters(),
                new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider, PHRASEIDBYDATAMD5_BS)
        );
    }

    @PreDestroy
    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public YtDynamicContext getContext() {
        List<YtCluster> clusters = clusterChooser.getClustersOrdered().orElseThrow(() -> new IllegalStateException(
                "No available clusters for " + PHRASEIDBYDATAMD5_BS.getName()));
        return new YtDynamicContext(ytProvider, clusters, SELECT_TIMEOUT);
    }
}
