package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.grid.schema.yt.Tables;
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

@Component
public class SitelinksImportDynContextProvider extends BaseDynContextProvider {

    public SitelinksImportDynContextProvider(YtDynamicConfig ytDynamicConfig,
                                             DirectYtDynamicConfig directYtDynamicConfig,
                                             TableAvailabilityChecker tableAvailabilityChecker,
                                             YtProvider ytProvider) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        Tables.IMPORT_FROM_BNO_SITELINKS),
                DirectYtDynamicConfig::getSitelinksImportClusters,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }

}
