package ru.yandex.direct.ytcomponents.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.selector.QueryBasedClusterWeightFunction;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

import static ru.yandex.direct.grid.schema.yt.Tables.TAXHISTORY_BS;

@Component
public class TaxHistoryDynContextProvider extends BaseDynContextProvider {

    public TaxHistoryDynContextProvider(DirectYtDynamicConfig directYtDynamicConfig, YtProvider ytProvider,
                                        TableAvailabilityChecker tableAvailabilityChecker,
                                        YtDynamicConfig ytDynamicConfig) {
        super(directYtDynamicConfig, ytProvider,
                () -> new QueryBasedClusterWeightFunction(tableAvailabilityChecker, ytProvider,
                        TAXHISTORY_BS),
                ytDynamicConfig.defaultSelectRowsTimeout());
    }
}
