package ru.yandex.direct.ytcomponents.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ytcomponents.config.BrandSurveyStatusDynConfig;
import ru.yandex.direct.ytcomponents.config.BsExportYtDynConfig;
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytcomponents.repository.YtClusterFreshnessRepository;
import ru.yandex.direct.ytwrapper.client.YtClusterConfigProvider;
import ru.yandex.direct.ytwrapper.client.YtClusterTypesafeConfigProvider;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.TableMappings;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicTypesafeConfig;
import ru.yandex.direct.ytwrapper.dynamic.YtQueryComposer;
import ru.yandex.direct.ytwrapper.utils.TableAvailabilityChecker;

@Configuration
@Import(value = {
        EssentialConfiguration.class,
})
@ComponentScan(
        basePackages = "ru.yandex.direct.ytcomponents",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class YtComponentsConfiguration {

    @Bean
    public YtDynamicConfig ytDynamicConfig(DirectConfig directConfig) {
        DirectConfig ytConfig = directConfig.getBranch("yt");
        return new YtDynamicTypesafeConfig(ytConfig.getConfig());
    }

    @Bean
    public DirectYtDynamicConfig directYtDynamicConfig(DirectConfig directConfig) {
        return new DirectYtDynamicConfig(directConfig.getBranch("dynamic-yt"));
    }

    @Bean
    @Lazy
    public YtProvider ytProvider(DirectConfig directConfig, YtDynamicConfig dynConfig,
                                 YtQueryComposer ytQueryComposer) {
        DirectConfig ytConfig = directConfig.getBranch("yt");
        YtClusterConfigProvider ytClusterConfigProvider = new YtClusterTypesafeConfigProvider(ytConfig.getConfig());
        return new YtProvider(ytClusterConfigProvider, dynConfig, ytQueryComposer);
    }

    @Bean
    public YtQueryComposer ytQueryComposer(TableMappings tableMappings, EnvironmentType environmentType) {
        boolean enablePrettyPrint = environmentType.isDevelopment();
        return new YtQueryComposer(tableMappings, enablePrettyPrint);
    }

    @Bean
    public TableAvailabilityChecker tableAvailabilityChecker(TableMappings tableMappings) {
        return new TableAvailabilityChecker(tableMappings);
    }

    @Bean
    @Lazy
    public YtClusterFreshnessRepository ytClusterFreshnessRepository(DirectYtDynamicConfig dynamicConfig) {
        return new YtClusterFreshnessRepository(dynamicConfig);
    }

    @Bean
    public BrandSurveyStatusDynConfig brandSurveyStatsDynConfig(DirectConfig directConfig) {
        return new BrandSurveyStatusDynConfig(directConfig);
    }

    @Bean
    public BsExportYtDynConfig bsExportYtDynConfig(DirectConfig directConfig) {
        return new BsExportYtDynConfig(directConfig.getBranch("bs-export.yt"));
    }
}
