package ru.yandex.direct.ytcomponents.statistics.service;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.ytcomponents.model.CampaignDeal;
import ru.yandex.direct.ytcomponents.model.DealStatsResponse;
import ru.yandex.direct.ytcomponents.statistics.repository.CampaignStatRepository;

/**
 * Сервис, умеющий доставать позаказную статитику по показам из YT.
 */
@Service
@ParametersAreNonnullByDefault
public class CampaignStatService {

    private final CampaignStatRepository campaignStatRepository;

    @Autowired
    public CampaignStatService(CampaignStatRepository campaignStatRepository) {
        this.campaignStatRepository = campaignStatRepository;
    }

    /**
     * Для указанных связок кампания-сделка возвращает статистику, сгруппированную по сделкам
     *
     * @see CampaignStatRepository#getDealsStatistics(Collection)
     */
    public Map<Long, DealStatsResponse> getDealsStatistics(Collection<CampaignDeal> requests) {
        return campaignStatRepository.getDealsStatistics(requests);
    }
}
