package ru.yandex.direct.ytcomponents.statistics.model;

import java.time.LocalDate;

public class DateRange {
    private LocalDate fromInclusive;
    private LocalDate toInclusive;

    public LocalDate getFromInclusive() {
        return fromInclusive;
    }

    public DateRange withFromInclusive(LocalDate fromInclusive) {
        this.fromInclusive = fromInclusive;
        return this;
    }

    public LocalDate getFromExclusive() {
        return fromInclusive.minusDays(1);
    }

    public DateRange withFromExclusive(LocalDate fromExclusive) {
        this.fromInclusive = fromExclusive.plusDays(1);
        return this;
    }

    public LocalDate getToInclusive() {
        return toInclusive;
    }

    public DateRange withToInclusive(LocalDate toInclusive) {
        this.toInclusive = toInclusive;
        return this;
    }

    public LocalDate getToExclusive() {
        return toInclusive.minusDays(1);
    }

    public DateRange withToExclusive(LocalDate toInclusive) {
        this.toInclusive = toInclusive.minusDays(1);
        return this;
    }

    @Override
    public String toString() {
        return "DateRange{" +
                "fromInclusive=" + fromInclusive +
                ", toInclusive=" + toInclusive +
                '}';
    }
}
