package ru.yandex.direct.ytcomponents.statistics.model;

import org.jooq.types.ULong;

import static com.google.common.base.Preconditions.checkState;

/**
 * Описание параметров запроса статистики.
 */
public class PhraseStatisticsRequest {

    private final Long campaignId;
    private final Long adGroupId;
    private final Long bannerId;
    private final Long phraseId;
    private final ULong bsPhraseId;

    private PhraseStatisticsRequest(Long campaignId, Long adGroupId, Long bannerId, Long phraseId, ULong bsPhraseId) {
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.bannerId = bannerId;
        this.phraseId = phraseId;
        this.bsPhraseId = bsPhraseId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public Long getPhraseId() {
        return phraseId;
    }

    public ULong getBsPhraseId() {
        return bsPhraseId;
    }

    @Override
    public String toString() {
        return "PhraseStatisticsRequest{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", bannerId=" + bannerId +
                ", bsPhraseId=" + bsPhraseId +
                '}';
    }

    /**
     * Builder с валидацией корректного заполнения {@link PhraseStatisticsRequest}'а
     */
    public static class Builder {
        private Long campaignId;
        private Long adGroupId;
        private Long bannerId;
        private Long phraseId;
        private ULong bsPhraseId;

        public Builder withCampaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder withAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder withBannerId(Long bannerId) {
            this.bannerId = bannerId;
            return this;
        }

        public Builder withPhraseId(Long phraseId) {
            this.phraseId = phraseId;
            return this;
        }

        public Builder withBsPhraseId(ULong bsPhraseId) {
            this.bsPhraseId = bsPhraseId;
            return this;
        }

        public PhraseStatisticsRequest build() {
            checkState(campaignId != null, "CampaignId should be specified");
            checkState(adGroupId != null, "AdGroupId should be specified");
            // bannerId опционален
            checkState(bsPhraseId != null || phraseId != null, "PhraseId or BsPhraseId should be specified");
            return new PhraseStatisticsRequest(campaignId, adGroupId, bannerId, phraseId, bsPhraseId);
        }
    }
}
