package ru.yandex.direct.ytcomponents.statistics.model;

import java.util.Objects;

import org.jooq.types.ULong;

public class PhraseStatisticsResponse {
    private Long campaignId;
    private Long adGroupId;
    private Long bannerId;
    private Long phraseId;
    private ULong bsPhraseId;
    private ULong goalContextId;
    private Boolean mobile;
    private Long searchShows;
    private Long searchClicks;
    private Double searchEshows;
    private Long yaSearchShows;
    private Long yaSearchClicks;
    private Double yaSearchEshows;
    private Long networkShows;
    private Long networkClicks;
    private Double networkEshows;

    public PhraseStatisticsResponse withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public PhraseStatisticsResponse withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public PhraseStatisticsResponse withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public PhraseStatisticsResponse withPhraseId(Long phraseId) {
        this.phraseId = phraseId;
        return this;
    }

    @SuppressWarnings("WeakerAccess")
    public Long getPhraseId() {
        return phraseId;
    }

    public PhraseStatisticsResponse withBsPhraseId(ULong bsPhraseId) {
        this.bsPhraseId = bsPhraseId;
        return this;
    }

    @SuppressWarnings("WeakerAccess")
    public ULong getBsPhraseId() {
        return bsPhraseId;
    }

    public PhraseStatisticsResponse withGoalContextId(ULong goalContextId) {
        this.goalContextId = goalContextId;
        return this;
    }

    @SuppressWarnings("WeakerAccess")
    public ULong getGoalContextId() {
        return goalContextId;
    }

    public PhraseStatisticsResponse withMobile(Boolean isMobile) {
        this.mobile = isMobile;
        return this;
    }

    public Boolean isMobile() {
        return mobile;
    }

    public PhraseStatisticsResponse withYaSearchShows(Long yaSearchShows) {
        this.yaSearchShows = yaSearchShows;
        return this;
    }

    public PhraseStatisticsResponse withSearchShows(long searchShows) {
        this.searchShows = searchShows;
        return this;
    }

    public long getSearchShows() {
        return searchShows;
    }

    public PhraseStatisticsResponse withSearchClicks(long searchClicks) {
        this.searchClicks = searchClicks;
        return this;
    }

    public long getSearchClicks() {
        return searchClicks;
    }

    public PhraseStatisticsResponse withSearchEshows(double searchEshows) {
        this.searchEshows = searchEshows;
        return this;
    }

    public double getSearchEshows() {
        return searchEshows;
    }

    public Long getYaSearchShows() {
        return yaSearchShows;
    }

    public PhraseStatisticsResponse withYaSearchClicks(Long yaSearchClicks) {
        this.yaSearchClicks = yaSearchClicks;
        return this;
    }

    public Long getYaSearchClicks() {
        return yaSearchClicks;
    }

    public PhraseStatisticsResponse withYaSearchEshows(Double yaSearchEshows) {
        this.yaSearchEshows = yaSearchEshows;
        return this;
    }

    public Double getYaSearchEshows() {
        return yaSearchEshows;
    }

    public Long getNetworkShows() {
        return networkShows;
    }

    public PhraseStatisticsResponse withNetworkShows(Long networkShows) {
        this.networkShows = networkShows;
        return this;
    }

    public Long getNetworkClicks() {
        return networkClicks;
    }

    public PhraseStatisticsResponse withNetworkClicks(Long networkClicks) {
        this.networkClicks = networkClicks;
        return this;
    }

    public Double getNetworkEshows() {
        return networkEshows;
    }

    public PhraseStatisticsResponse withNetworkEshows(Double networkEshows) {
        this.networkEshows = networkEshows;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PhraseStatisticsResponse that = (PhraseStatisticsResponse) o;
        return Objects.equals(getCampaignId(), that.getCampaignId()) &&
                Objects.equals(getAdGroupId(), that.getAdGroupId()) &&
                Objects.equals(getBannerId(), that.getBannerId()) &&
                Objects.equals(getPhraseId(), that.getPhraseId()) &&
                Objects.equals(getBsPhraseId(), that.getBsPhraseId()) &&
                Objects.equals(getGoalContextId(), that.getGoalContextId()) &&
                Objects.equals(isMobile(), that.isMobile()) &&
                Objects.equals(getSearchShows(), that.getSearchShows()) &&
                Objects.equals(getSearchClicks(), that.getSearchClicks()) &&
                Objects.equals(getSearchEshows(), that.getSearchEshows()) &&
                Objects.equals(getYaSearchShows(), that.getYaSearchShows()) &&
                Objects.equals(getYaSearchClicks(), that.getYaSearchClicks()) &&
                Objects.equals(getYaSearchEshows(), that.getYaSearchEshows()) &&
                Objects.equals(getNetworkShows(), that.getNetworkShows()) &&
                Objects.equals(getNetworkClicks(), that.getNetworkClicks()) &&
                Objects.equals(getNetworkEshows(), that.getNetworkEshows());
    }

    @Override
    public int hashCode() {

        return Objects
                .hash(getCampaignId(), getAdGroupId(), getBannerId(), getPhraseId(), getBsPhraseId(),
                        getGoalContextId(), isMobile(),
                        getSearchShows(), getSearchClicks(), getSearchEshows(),
                        getYaSearchShows(), getYaSearchClicks(), getYaSearchEshows(),
                        getNetworkShows(), getNetworkClicks(), getNetworkEshows());
    }

    /**
     * Возвращает индекс, однозначно определяющий баннерофразу
     */
    public PhraseStatIndex phraseStatIndex() {
        return new PhraseStatIndex();
    }

    public class PhraseStatIndex {

        private PhraseStatIndex() {
        }

        public Long getCampaignId() {
            return campaignId;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public Long getBannerId() {
            return bannerId;
        }

        public Long getPhraseId() {
            return phraseId;
        }

        public ULong getBsPhraseId() {
            return bsPhraseId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            PhraseStatIndex statIndex = (PhraseStatIndex) o;
            return Objects.equals(campaignId, statIndex.getCampaignId()) &&
                    Objects.equals(adGroupId, statIndex.getAdGroupId()) &&
                    Objects.equals(bannerId, statIndex.getBannerId()) &&
                    Objects.equals(phraseId, statIndex.getPhraseId()) &&
                    Objects.equals(bsPhraseId, statIndex.getBsPhraseId());
        }

        @Override
        public int hashCode() {
            return Objects.hash(campaignId, adGroupId, bannerId, phraseId, bsPhraseId);
        }
    }

    public ShowConditionStatIndex showConditionStatIndex() {
        return new ShowConditionStatIndex();
    }

    public class ShowConditionStatIndex {

        private ShowConditionStatIndex() {
        }

        public Long getCampaignId() {
            return campaignId;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public Long getPhraseId() {
            return phraseId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ShowConditionStatIndex statIndex = (ShowConditionStatIndex) o;
            return Objects.equals(campaignId, statIndex.getCampaignId()) &&
                    Objects.equals(adGroupId, statIndex.getAdGroupId()) &&
                    Objects.equals(phraseId, statIndex.getPhraseId());
        }

        @Override
        public int hashCode() {
            return Objects.hash(campaignId, adGroupId, phraseId);
        }
    }

    public GoalContextStatIndex goalContextStatIndex() {
        return new GoalContextStatIndex();
    }

    public class GoalContextStatIndex {

        private GoalContextStatIndex() {
        }

        public Long getCampaignId() {
            return campaignId;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public ULong getGoalContextId() {
            return goalContextId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            GoalContextStatIndex statIndex = (GoalContextStatIndex) o;
            return Objects.equals(campaignId, statIndex.getCampaignId()) &&
                    Objects.equals(adGroupId, statIndex.getAdGroupId()) &&
                    Objects.equals(goalContextId, statIndex.getGoalContextId());
        }

        @Override
        public int hashCode() {
            return Objects.hash(campaignId, adGroupId, phraseId);
        }
    }
}
