package ru.yandex.direct.ytcomponents.statistics.model;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Описание параметров запроса статистики.
 */
public class RetargetingStatisticsRequest {

    private final Long campaignId;
    private final Long adGroupId;
    private final Long retargetingConditionId;

    private RetargetingStatisticsRequest(Long campaignId, Long adGroupId, Long retargetingConditionId) {
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.retargetingConditionId = retargetingConditionId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getRetargetingConditionId() {
        return retargetingConditionId;
    }

    /**
     * Builder с валидацией корректного заполнения {@link RetargetingStatisticsRequest}'а
     */
    public static class Builder {
        private Long campaignId;
        private Long adGroupId;
        private Long retargetingConditionId;

        public Builder withCampaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder withAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder withRetargetingConditionId(Long retargetingConditionId) {
            this.retargetingConditionId = retargetingConditionId;
            return this;
        }

        public RetargetingStatisticsRequest build() {
            checkNotNull(campaignId, "CampaignId should be specified");
            checkNotNull(adGroupId, "AdGroupId should be specified");
            checkNotNull(retargetingConditionId, "RetargetingConditionId should be specified");

            return new RetargetingStatisticsRequest(campaignId, adGroupId, retargetingConditionId);
        }
    }
}
