package ru.yandex.direct.ytcomponents.statistics.model;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Описание параметров запроса статистики по условию показа.
 */
public class ShowConditionStatisticsRequest {

    private final Long campaignId;
    private final Long adGroupId;
    private final Long showConditionId;

    private ShowConditionStatisticsRequest(Long campaignId, Long adGroupId, Long showConditionId) {
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.showConditionId = showConditionId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getShowConditionId() {
        return showConditionId;
    }

    /**
     * Builder с валидацией корректного заполнения {@link ShowConditionStatisticsRequest}'а
     */
    public static class Builder {
        private Long campaignId;
        private Long adGroupId;
        private Long showConditionId;

        public Builder withCampaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder withAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder withShowConditionId(Long showConditionId) {
            this.showConditionId = showConditionId;
            return this;
        }

        public ShowConditionStatisticsRequest build() {
            checkNotNull(campaignId, "CampaignId should be specified");
            checkNotNull(adGroupId, "AdGroupId should be specified");
            checkNotNull(showConditionId, "ShowConditionId should be specified");

            return new ShowConditionStatisticsRequest(campaignId, adGroupId, showConditionId);
        }
    }
}
