package ru.yandex.direct.ytcomponents.statistics.model;

import ru.yandex.direct.core.entity.keyword.model.KeywordRecentStatistics;

/**
 * Аггрегатор статистики показов/кликов на поиске и в сетях.
 */
public class StatValueAggregator implements KeywordRecentStatistics {
    private Long searchShows;
    private Long searchClicks;
    private Double searchEshows;
    private Long networkShows;
    private Long networkClicks;
    private Double networkEshows;

    public StatValueAggregator() {
        searchClicks = 0L;
        searchShows = 0L;
        searchEshows = 0.0;
        networkClicks = 0L;
        networkShows = 0L;
        networkEshows = 0.0;
    }

    public Long getSearchShows() {
        return searchShows;
    }

    public StatValueAggregator addSearchShows(Long shows) {
        searchShows += shows;
        return this;
    }

    public Long getSearchClicks() {
        return searchClicks;
    }

    public StatValueAggregator addSearchClicks(Long clicks) {
        searchClicks += clicks;
        return this;
    }

    public Double getSearchEshows() {
        return searchEshows;
    }

    public StatValueAggregator addSearchEshows(Double eshows) {
        searchEshows += eshows;
        return this;
    }


    public Long getNetworkShows() {
        return networkShows;
    }

    public StatValueAggregator addNetworkShows(Long shows) {
        networkShows += shows;
        return this;
    }


    public Long getNetworkClicks() {
        return networkClicks;
    }

    public StatValueAggregator addNetworkClicks(Long clicks) {
        networkClicks += clicks;
        return this;
    }

    public Double getNetworkEshows() {
        return networkEshows;
    }

    public StatValueAggregator addNetworkEshows(Double eshows) {
        networkEshows += eshows;
        return this;
    }

    public StatValueAggregator add(StatValueAggregator other) {
        addSearchClicks(other.getSearchClicks());
        addSearchShows(other.getSearchShows());
        addSearchEshows(other.getSearchEshows());

        addNetworkClicks(other.getNetworkClicks());
        addNetworkShows(other.getNetworkShows());
        addNetworkEshows(other.getNetworkEshows());

        return this;
    }
}
