package ru.yandex.direct.ytcore.entity.recommendation.service.typesupport;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.core.entity.recommendation.model.RecommendationQueueInfo;

import static java.util.Collections.singleton;
import static java.util.Collections.singletonList;

/**
 * Удаляет площадку из списка запрещенных (изменяет поле campaigns.DontShow)
 */
@Component
@ParametersAreNonnullByDefault
public class RecommendationRemoveFromBlackListOfCampaignTypeSupport implements RecommendationTypeSupport {
    private final CampaignService campaignService;

    @Autowired
    public RecommendationRemoveFromBlackListOfCampaignTypeSupport(
            CampaignService campaignService) {
        this.campaignService = campaignService;
    }

    @Override
    public boolean apply(int shard, RecommendationQueueInfo recommendation) {
        // Для данной рекомендации в поле "recommendations_queue.user_key_1" кладется домен, который надо исключить
        // из черного списка.
        campaignService.removeDomainFromDisabled(shard, singletonList(recommendation.getCampaignId()),
                recommendation.getUserKey1());
        return true;
    }

    @Override
    public Set<RecommendationType> getTypes() {
        return singleton(RecommendationType.removePagesFromBlackListOfACampaign);
    }
}



