package ru.yandex.direct.ytcore.entity.recommendation.service.typesupport;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.service.CampaignService;
import ru.yandex.direct.core.entity.recommendation.RecommendationType;
import ru.yandex.direct.core.entity.recommendation.model.RecommendationQueueInfo;

import static java.util.Collections.singleton;
import static java.util.Collections.singletonList;

/**
 * Удаляет площадку из списка запрещенных (изменяет поле campaigns.DontShow)
 */
@Component
@ParametersAreNonnullByDefault
public class RecommendationRemoveFromBlackListTypeSupport implements RecommendationTypeSupport {
    private static final Logger logger = LoggerFactory.getLogger(RecommendationRemoveFromBlackListTypeSupport.class);
    private final CampaignService campaignService;

    @Autowired
    public RecommendationRemoveFromBlackListTypeSupport(
            CampaignService campaignService) {
        this.campaignService = campaignService;
    }

    @Override
    public boolean apply(int shard, RecommendationQueueInfo recommendation) {
        campaignService.removeDomainFromDisabled(shard, singletonList(recommendation.getCampaignId()), recommendation.getUserKey1());
        return true;
    }

    @Override
    public Set<RecommendationType> getTypes() {
        return singleton(RecommendationType.removePagesFromBlackList);
    }
}



