package ru.yandex.direct.ytcore.entity.recommendation.service.typesupport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.recommendation.RecommendationType;

@Component
@ParametersAreNonnullByDefault
public class RecommendationTypeSupportDispatcher {
    private final Map<RecommendationType, RecommendationTypeSupport> typeSupportMap;

    @Autowired
    public RecommendationTypeSupportDispatcher(List<RecommendationTypeSupport> typeSupportList) {
        typeSupportMap = new HashMap<>();
        for (RecommendationTypeSupport recommendationTypeSupport : typeSupportList) {
            for (RecommendationType recommendationType : recommendationTypeSupport.getTypes()) {
                typeSupportMap.put(recommendationType, recommendationTypeSupport);
            }
        }
    }

    public RecommendationTypeSupport getTypeSupport(RecommendationType type) {
        return typeSupportMap.get(type);
    }
}



