package ru.yandex.direct.ytcore.entity.statistics.repository

import org.jooq.impl.DSL.field
import org.springframework.stereotype.Repository
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytcomponents.service.ActStatDynContextProvider
import ru.yandex.direct.ytcomponents.statistics.model.ActMoneyStat
import ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL

@Repository
class ActMoneyStatisticsRepository(
    private val contextProvider: ActStatDynContextProvider,
    ytDynamicConfig: DirectYtDynamicConfig
) {
    companion object {
        private val CAMPAIGN_ID = field("cid", Long::class.java)
        private val TIMESTAMP = field("timestamp", Long::class.java)
        private val SHOWS = field("shows", Long::class.java)
        private val CLICKS = field("clicks", Long::class.java)
        private val CONVERSIONS = field("conversions", Long::class.java)
        private val TOTAL = field("total", Long::class.java)
        private val MONEY = field("money", Long::class.java)
        private val BONUS = field("bonus", Long::class.java)
        private val PROMO = field("promo", Long::class.java)
        private val SALES = field("sales", Long::class.java)
        private val CERTS = field("certs", Long::class.java)
        private val BACKS = field("backs", Long::class.java)
    }

    private val tablePath = ytDynamicConfig.tables().actMoneyStatsTables().actMoneyStatsTablePath()

    fun getActStatistics(campaignIds: Collection<Long>, timeFrom: Long, timeTo: Long): List<ActMoneyStat> {
        return contextProvider.context.executeSelect(
            YtDSL.ytContext()
                .select(
                    CAMPAIGN_ID, TIMESTAMP, SHOWS, CLICKS, CONVERSIONS,
                    TOTAL, MONEY, BONUS, PROMO, SALES, CERTS, BACKS
                )
                .from("[$tablePath]")
                .where(CAMPAIGN_ID.`in`(campaignIds))
                .and(TIMESTAMP.between(timeFrom, timeTo))
        ).yTreeRows.map {
            ActMoneyStat(
                cid = it.getLong(CAMPAIGN_ID.name),
                shows = it.getLong(SHOWS.name),
                clicks = it.getLong(CLICKS.name),
                conversions = it.getLong(CONVERSIONS.name),
                total = it.getLong(TOTAL.name),
                money = it.getLong(MONEY.name),
                bonus = it.getLong(BONUS.name),
                promo = it.getLong(PROMO.name),
                sales = it.getLong(SALES.name),
                certs = it.getLong(CERTS.name),
                backs = it.getLong(BACKS.name),
                timestamp = it.getLong(TIMESTAMP.name)
            )
        }
    }
}
