package ru.yandex.direct.ytcore.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.communication.config.CommunicationConfiguration;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.keyword.service.KeywordRecentStatisticsProvider;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ytcomponents.service.PhraseStatsDynContextProvider;
import ru.yandex.direct.ytcomponents.spring.YtComponentsConfiguration;
import ru.yandex.direct.ytcore.entity.statistics.repository.RecentStatisticsRepository;
import ru.yandex.direct.ytcore.entity.statistics.repository.RecentStatisticsSandboxRepository;
import ru.yandex.direct.ytcore.entity.statistics.service.RecentStatisticsService;

@Configuration
@Import(value = {
        EssentialConfiguration.class,
        CoreConfiguration.class,
        YtComponentsConfiguration.class,
        CommunicationConfiguration.class
})
@ComponentScan(
        basePackages = "ru.yandex.direct.ytcore",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class YtCoreConfiguration {
    @Bean
    public RecentStatisticsRepository recentStatisticsRepository(EnvironmentType environmentType,
                                                                 PhraseStatsDynContextProvider contextProvider) {
        return environmentType.isSandbox()
                ? new RecentStatisticsSandboxRepository(contextProvider)
                : new RecentStatisticsRepository(contextProvider);
    }

    @Bean(name = CoreConfiguration.DEFAULT_COPY_RECENT_STATISTICS_PROVIDER_BEAN_NAME)
    public KeywordRecentStatisticsProvider keywordRecentStatisticsProvider(
            RecentStatisticsService recentStatisticsService) {
        return recentStatisticsService;
    }
}
