package ru.yandex.direct.advq;

import ru.yandex.direct.advq.search.ParserType;

public class AdvqSearchOptions {

    private ParserType parserType;
    private Boolean calcTotalHits;
    private Boolean assocs;
    private Boolean fastMode;
    private Integer phPage;
    private Integer phPageSize;

    public ParserType getParserType() {
        return parserType;
    }

    public AdvqSearchOptions withParserType(ParserType parserType) {
        this.parserType = parserType;
        return this;
    }

    public Boolean getCalcTotalHits() {
        return calcTotalHits;
    }

    public AdvqSearchOptions withCalcTotalHits(Boolean calcTotalHits) {
        this.calcTotalHits = calcTotalHits;
        return this;
    }

    public Boolean getAssocs() {
        return assocs;
    }

    public AdvqSearchOptions withAssocs(Boolean assocs) {
        this.assocs = assocs;
        return this;
    }

    public Boolean getFastMode() {
        return fastMode;
    }

    public AdvqSearchOptions withFastMode(Boolean fastMode) {
        this.fastMode = fastMode;
        return this;
    }

    public Integer getPhPage() {
        return phPage;
    }

    public AdvqSearchOptions withPhPage(Integer phPage) {
        this.phPage = phPage;
        return this;
    }

    public Integer getPhPageSize() {
        return phPageSize;
    }

    public AdvqSearchOptions withPhPageSize(Integer phPageSize) {
        this.phPageSize = phPageSize;
        return this;
    }
}
