package ru.yandex.direct.advq;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.advq.checkminhits.CheckMinHitsItem;

/**
 * Результат операции check_min_hits в ADVQ, или разбивка наличия кликов по устройствам и ключевым фразам, или список
 * ощибок, которые помешали разбивку получить
 */
@ParametersAreNonnullByDefault
public class CheckMinHitsResult {
    private Map<String, Map<String, CheckMinHitsItem>> results;
    private List<Throwable> errors;

    private CheckMinHitsResult(Map<String, Map<String, CheckMinHitsItem>> results) {
        this.results = results;
    }

    private CheckMinHitsResult(List<Throwable> errors) {
        this.errors = errors;
    }

    /**
     * @return завершилась ли операция успешно
     */
    public boolean isSuccessful() {
        return results != null;
    }

    /**
     * Возвращает результаты при успешном завершении операции, иначе null
     *
     * @return результаты операции в виде словаря устройство -> словарь ключевая фраза -> результат запроса
     */
    public Map<String, Map<String, CheckMinHitsItem>> getResults() {
        return results;
    }

    /**
     * Возвращает список ошибок при неуспешном завершении операции, иначе null
     *
     * @return ошибки операции в виде списка Throwable
     */
    public List<Throwable> getErrors() {
        return errors;
    }

    /**
     * Фабричный метод для успешного завершения операции
     *
     * @param results результаты операции в виде словаря устройство -> словарь ключевая фраза -> результат запроса
     */
    public static CheckMinHitsResult success(Map<String, Map<String, CheckMinHitsItem>> results) {
        return new CheckMinHitsResult(results);
    }

    /**
     * Фабричный метод для ошибочного завершения операци
     *
     * @param errors список ошибок
     */
    public static CheckMinHitsResult failure(List<Throwable> errors) {
        return new CheckMinHitsResult(errors);
    }
}
