package ru.yandex.direct.advq;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.advq.search.SearchItem;

public class SearchKeywordResult {
    private SearchItem result;
    private final List<Throwable> errors;

    private SearchKeywordResult(SearchItem result, List<Throwable> errors) {
        this.result = result;
        this.errors = errors;
    }

    public boolean hasErrors() {
        return errors != null;
    }

    /**
     * @return список ошибок (если были)
     */
    @Nullable
    public List<Throwable> getErrors() {
        return errors;
    }

    /**
     * @return результат поиска
     */
    @Nullable
    public SearchItem getResult() {
        return result;
    }

    /**
     * @return является ли ответ "пустым", то есть мы не получили ответа от advq конкретно на этот запрос
     */
    public boolean isEmpty() {
        return result == null && errors == null;
    }

    /**
     * Создает "пустой" ответ, означает, что advq не вернул ответ по этому запросу
     */
    public static SearchKeywordResult empty() {
        return new SearchKeywordResult(null, null);
    }

    /**
     * Создает корректный ответ
     *
     * @param result результат поиска
     */
    public static SearchKeywordResult success(SearchItem result) {
        return new SearchKeywordResult(result, null);
    }

    /**
     * Создает некорректный ответ
     *
     * @param errors Список ошибок
     */
    public static SearchKeywordResult failure(List<Throwable> errors) {
        return new SearchKeywordResult(null, errors);
    }

    /**
     * @return {@code true}, если поиск не вернул никаких результатов кроме, может быть, ошибок
     */
    public boolean isError() {
        return hasErrors() || result == null || result.getStat() == null;
    }
}
