package ru.yandex.direct.advq;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.advq.search.AdvqRequestKeyword;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class SearchRequest {
    private final List<AdvqRequestKeyword> keywords;
    private final List<Long> regionIds;
    private Set<Device> deviceTypes;

    public SearchRequest(List<AdvqRequestKeyword> keywords, List<Long> regionIds) {
        this.keywords = Objects.requireNonNull(keywords, "keywords");
        this.regionIds = Objects.requireNonNull(regionIds, "regionIds");
    }

    public static SearchRequest fromPhrases(List<String> phrases, List<Long> regionIds) {
        return new SearchRequest(mapList(phrases, AdvqRequestKeyword::new), regionIds);
    }

    public SearchRequest withDeviceTypes(Set<Device> deviceTypes) {
        this.deviceTypes = deviceTypes;
        return this;
    }

    public List<AdvqRequestKeyword> getKeywords() {
        return keywords;
    }

    public List<Long> getRegionIds() {
        return regionIds;
    }

    public Set<Device> getDeviceTypes() {
        return deviceTypes;
    }

    @Override
    public String toString() {
        return "SearchRequest{" +
                "keywords=" + keywords +
                ", regionIds=" + regionIds +
                ", deviceTypes=" + deviceTypes +
                '}';
    }
}
