package ru.yandex.direct.advq.search;

import java.util.Objects;

import javax.annotation.Nullable;

public class AdvqRequestKeyword {

    private final String phrase;
    private final Long keywordId;

    public AdvqRequestKeyword(String phrase) {
        this(phrase, null);
    }

    public AdvqRequestKeyword(String phrase, Long keywordId) {
        this.phrase = phrase;
        this.keywordId = keywordId;
    }

    public String getPhrase() {
        return phrase;
    }

    @Nullable
    public Long getKeywordId() {
        return keywordId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdvqRequestKeyword that = (AdvqRequestKeyword) o;
        return Objects.equals(phrase, that.phrase) && Objects.equals(keywordId, that.keywordId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(phrase, keywordId);
    }
}
