package ru.yandex.direct.advq.search;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.advq.SearchRequest;

public class SearchChunkedRequests {
    /**
     * Отображение id запроса к запросу
     */
    private Map<Long, SearchRequest> idToRequest;
    /**
     * Отображение id запроса к чанку запроса
     */
    private Map<Long, List<AdvqRequestKeyword>> idToChunk;
    /**
     * Запросы, разбитые по чанкам
     */
    private List<AdvqSearchRequest> chunkedRequests;

    public SearchChunkedRequests(
            Map<Long, SearchRequest> idToRequest,
            Map<Long, List<AdvqRequestKeyword>> idToChunk,
            List<AdvqSearchRequest> chunkedRequests) {
        this.idToRequest = idToRequest;
        this.idToChunk = idToChunk;
        this.chunkedRequests = chunkedRequests;
    }

    public Map<Long, SearchRequest> getIdToRequest() {
        return idToRequest;
    }

    public Map<Long, List<AdvqRequestKeyword>> getIdToChunk() {
        return idToChunk;
    }

    public List<AdvqSearchRequest> getChunkedRequests() {
        return chunkedRequests;
    }
}
