package ru.yandex.direct.advq.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Обертка над JSON в ответе ADVQ, метод Search
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SearchItem {
    private Statistics stat;
    private String req;

    public SearchItem() {
    }

    public Statistics getStat() {
        return stat;
    }

    public void setStat(Statistics stat) {
        this.stat = stat;
    }

    public String getReq() {
        return req;
    }

    public void setReq(String req) {
        this.req = req;
    }

    public SearchItem withStat(Statistics stat) {
        this.stat = stat;
        return this;
    }

    public SearchItem withReq(String req) {
        this.req = req;
        return this;
    }

    /**
     * @return общее количество показов
     */
    @JsonIgnore
    public long getTotalCount() {
        return stat.getTotalCount();
    }
}
