package ru.yandex.direct.advq.search;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;

import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import ru.yandex.direct.asynchttp.AbstractParsableRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class SearchParsableRequest extends AbstractParsableRequest<SearchResponse> {
    public SearchParsableRequest(long id, Request request) {
        super(id, request);
    }

    @Override
    public Function<Response, SearchResponse> getParseFunction() {
        return response ->
                fromJson(response.getResponseBody(StandardCharsets.UTF_8), SearchResponse.class);
    }
}
