package ru.yandex.direct.advq.search;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Обертка над JSON ответом ADVQ, метод Search
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Statistics {
    private List<StatisticsPhraseItem> associations;
    private List<StatisticsPhraseItem> includingPhrases;
    private long totalCount;
    private List<String> errors;
    private boolean validQuery;
    private boolean hasNextPage;

    public List<StatisticsPhraseItem> getAssociations() {
        return associations;
    }

    public void setAssociations(List<StatisticsPhraseItem> associations) {
        this.associations = associations;
    }

    public List<StatisticsPhraseItem> getIncludingPhrases() {
        return includingPhrases;
    }

    public void setIncludingPhrases(List<StatisticsPhraseItem> includingPhrases) {
        this.includingPhrases = includingPhrases;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public List<String> getErrors() {
        return errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean isValidQuery() {
        return validQuery;
    }

    public void setValidQuery(boolean validQuery) {
        this.validQuery = validQuery;
    }

    public Statistics withTotalCount(long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public boolean isHasNextPage() {
        return hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

}
