package ru.yandex.direct.advq.search;

import java.nio.charset.Charset;

import org.asynchttpclient.Response;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class SearchParsableRequestTest {
    @Test
    public void parseWithAssociationsTest() {
        Response mockResponse = mock(Response.class);
        when(mockResponse.getResponseBody(any(Charset.class))).thenReturn(responseWithAssociations);

        SearchResponse response = new SearchParsableRequest(0, null).getParseFunction()
                .apply(mockResponse);

        assertEquals(2, response.getSearchItems().size());
    }

    @Test
    public void parseWithRegionsTest() {
        Response mockResponse = mock(Response.class);
        when(mockResponse.getResponseBody(any(Charset.class))).thenReturn(responseWithRegions);

        SearchResponse response = new SearchParsableRequest(0, null).getParseFunction()
                .apply(mockResponse);

        assertEquals(2, response.getSearchItems().size());

    }

    private String responseWithAssociations = "{\n"
            + "\t\"requests\": [\n"
            + "\t\t{\n"
            + "\t\t\t\"lang\": \"RUS\",\n"
            + "\t\t\t\"stat\": {\n"
            + "\t\t\t\t\"associations\": [\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"производитель носок\",\n"
            + "\t\t\t\t\t\t\"cnt\": 5258\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"магазин носок\",\n"
            + "\t\t\t\t\t\t\"cnt\": 8256\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"носок москва\",\n"
            + "\t\t\t\t\t\t\"cnt\": 5578\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"носок мужской\",\n"
            + "\t\t\t\t\t\t\"cnt\": 31869\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"опт носок\",\n"
            + "\t\t\t\t\t\t\"cnt\": 23674\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"носок цена\",\n"
            + "\t\t\t\t\t\t\"cnt\": 5567\n"
            + "\t\t\t\t\t}\n"
            + "\t\t\t\t],\n"
            + "\t\t\t\t\"db_date_str\": \"25/04/2017\",\n"
            + "\t\t\t\t\"db_timestamp\": 1493108345,\n"
            + "\t\t\t\t\"overall_time\": 0.04801297187805176,\n"
            + "\t\t\t\t\"including_phrases\": [\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"купить носки\",\n"
            + "\t\t\t\t\t\t\"cnt\": 56253\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"купить носки мужские\",\n"
            + "\t\t\t\t\t\t\"cnt\": 7128\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"купить носки оптом\",\n"
            + "\t\t\t\t\t\t\"cnt\": 6380\n"
            + "\t\t\t\t\t}\n"
            + "\t\t\t\t],\n"
            + "\t\t\t\t\"total_count\": 56253,\n"
            + "\t\t\t\t\"page_count\": 738,\n"
            + "\t\t\t\t\"precision\": 1.0,\n"
            + "\t\t\t\t\"db_info\": {\n"
            + "\t\t\t\t\t\"sumhits\": \"20170321-20170419\",\n"
            + "\t\t\t\t\t\"phits\": \"20170321-20170419\",\n"
            + "\t\t\t\t\t\"quhits\": \"20170321-20170419\"\n"
            + "\t\t\t\t},\n"
            + "\t\t\t\t\"has_next_page\": true,\n"
            + "\t\t\t\t\"count_by_regions\": [],\n"
            + "\t\t\t\t\"errors\": [],\n"
            + "\t\t\t\t\"valid_query\": true,\n"
            + "\t\t\t\t\"tainted\": false,\n"
            + "\t\t\t\t\"search_time\": 0.004087924957275391,\n"
            + "\t\t\t\t\"rpn\": \"купить носки &2\"\n"
            + "\t\t\t},\n"
            + "\t\t\t\"req\": \"купить носки\",\n"
            + "\t\t\t\"dbname\": \"rus\"\n"
            + "\t\t},\n"
            + "\t\t{\n"
            + "\t\t\t\"lang\": \"RUS\",\n"
            + "\t\t\t\"stat\": {\n"
            + "\t\t\t\t\"associations\": [\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"купить обувь\",\n"
            + "\t\t\t\t\t\t\"cnt\": 577284\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"мужской обувь\",\n"
            + "\t\t\t\t\t\t\"cnt\": 226727\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"детский обувь\",\n"
            + "\t\t\t\t\t\t\"cnt\": 650392\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"женский обувь\",\n"
            + "\t\t\t\t\t\t\"cnt\": 363661\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"обувь магазин\",\n"
            + "\t\t\t\t\t\t\"cnt\": 1079921\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"обувь интернет\",\n"
            + "\t\t\t\t\t\t\"cnt\": 733532\n"
            + "\t\t\t\t\t}\n"
            + "\t\t\t\t],\n"
            + "\t\t\t\t\"db_date_str\": \"25/04/2017\",\n"
            + "\t\t\t\t\"db_timestamp\": 1493108345,\n"
            + "\t\t\t\t\"overall_time\": 0.04801297187805176,\n"
            + "\t\t\t\t\"including_phrases\": [\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"ботинки\",\n"
            + "\t\t\t\t\t\t\"cnt\": 882134\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"купить ботинки\",\n"
            + "\t\t\t\t\t\t\"cnt\": 136627\n"
            + "\t\t\t\t\t},\n"
            + "\t\t\t\t\t{\n"
            + "\t\t\t\t\t\t\"phrase\": \"ботинки женские\",\n"
            + "\t\t\t\t\t\t\"cnt\": 108815\n"
            + "\t\t\t\t\t}\n"
            + "\t\t\t\t],\n"
            + "\t\t\t\t\"total_count\": 882134,\n"
            + "\t\t\t\t\"page_count\": 10248,\n"
            + "\t\t\t\t\"precision\": 1.0,\n"
            + "\t\t\t\t\"db_info\": {\n"
            + "\t\t\t\t\t\"sumhits\": \"20170321-20170419\",\n"
            + "\t\t\t\t\t\"phits\": \"20170321-20170419\",\n"
            + "\t\t\t\t\t\"quhits\": \"20170321-20170419\"\n"
            + "\t\t\t\t},\n"
            + "\t\t\t\t\"has_next_page\": true,\n"
            + "\t\t\t\t\"count_by_regions\": [],\n"
            + "\t\t\t\t\"errors\": [],\n"
            + "\t\t\t\t\"valid_query\": true,\n"
            + "\t\t\t\t\"tainted\": false,\n"
            + "\t\t\t\t\"search_time\": 0.020248889923095703,\n"
            + "\t\t\t\t\"rpn\": \"ботинки\"\n"
            + "\t\t\t},\n"
            + "\t\t\t\"req\": \"ботинки\",\n"
            + "\t\t\t\"dbname\": \"rus\"\n"
            + "\t\t}\n"
            + "\t]\n"
            + "}";

    private String responseWithRegions = "{\n"
            + "\"requests\": [\n"
            + "{\n"
            + "\"lang\": \"RUS\",\n"
            + "\"stat\": {\n"
            + "\"associations\": [],\n"
            + "\"db_date_str\": \"25/04/2017\",\n"
            + "\"db_timestamp\": 1493108345,\n"
            + "\"overall_time\": 0.09121203422546387,\n"
            + "\"including_phrases\": [],\n"
            + "\"total_count\": 56253,\n"
            + "\"precision\": 1.0,\n"
            + "\"db_info\": {\n"
            + "\"sumhits\": \"20170321-20170419\",\n"
            + "\"phits\": \"20170321-20170419\",\n"
            + "\"quhits\": \"20170321-20170419\"\n"
            + "},\n"
            + "\"has_next_page\": false,\n"
            + "\"count_by_regions\": [\n"
            + "{\n"
            + "\"reg_id\": 1,\n"
            + "\"cnt\": 16137,\n"
            + "\"pp\": 1.447404835867521\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 2,\n"
            + "\"cnt\": 4112,\n"
            + "\"pp\": 1.3057372737221478\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 3,\n"
            + "\"cnt\": 19520,\n"
            + "\"pp\": 1.1838224058908215\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 4,\n"
            + "\"cnt\": 104,\n"
            + "\"pp\": 0.42687731938810547\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 5,\n"
            + "\"cnt\": 180,\n"
            + "\"pp\": 0.868824354500257\n"
            + "}\n"
            + "],\n"
            + "\"errors\": [],\n"
            + "\"valid_query\": true,\n"
            + "\"tainted\": false,\n"
            + "\"search_time\": 0.0033731460571289062,\n"
            + "\"rpn\": \"купить носки &2\"\n"
            + "},\n"
            + "\"req\": \"купить носки\",\n"
            + "\"dbname\": \"rus\"\n"
            + "},\n"
            + "{\n"
            + "\"lang\": \"RUS\",\n"
            + "\"stat\": {\n"
            + "\"associations\": [],\n"
            + "\"db_date_str\": \"25/04/2017\",\n"
            + "\"db_timestamp\": 1493108345,\n"
            + "\"overall_time\": 0.09121203422546387,\n"
            + "\"including_phrases\": [],\n"
            + "\"total_count\": 882134,\n"
            + "\"precision\": 1.0,\n"
            + "\"db_info\": {\n"
            + "\"sumhits\": \"20170321-20170419\",\n"
            + "\"phits\": \"20170321-20170419\",\n"
            + "\"quhits\": \"20170321-20170419\"\n"
            + "},\n"
            + "\"has_next_page\": false,\n"
            + "\"count_by_regions\": [\n"
            + "{\n"
            + "\"reg_id\": 1,\n"
            + "\"cnt\": 293783,\n"
            + "\"pp\": 1.6803703460902568\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 2,\n"
            + "\"cnt\": 61047,\n"
            + "\"pp\": 1.2361698568004362\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 3,\n"
            + "\"cnt\": 356386,\n"
            + "\"pp\": 1.3782833332751492\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 4,\n"
            + "\"cnt\": 2315,\n"
            + "\"pp\": 0.6059431272199554\n"
            + "},\n"
            + "{\n"
            + "\"reg_id\": 5,\n"
            + "\"cnt\": 3205,\n"
            + "\"pp\": 0.9865035269642705\n"
            + "}\n"
            + "],\n"
            + "\"errors\": [],\n"
            + "\"valid_query\": true,\n"
            + "\"tainted\": false,\n"
            + "\"search_time\": 0.0033180713653564453,\n"
            + "\"rpn\": \"ботинки\"\n"
            + "},\n"
            + "\"req\": \"ботинки\",\n"
            + "\"dbname\": \"rus\"\n"
            + "}\n"
            + "]\n"
            + "}";
}
