package ru.yandex.direct.ansiblejuggler.model.aggregators;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Параметры аггрегатора.
 * Специально сделан package-private, во избежание ошибок при генерации "снаружи"
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNonnullByDefault
class AggregatorParams {
    @JsonProperty
    @JsonUnwrapped
    private UnreachableParams unreachableParams;

    @JsonProperty(value = "downtimes_mode")
    private ParamsMode downtimesMode;

    /**
     * Сконструировать пустые параметры аггрегатора
     */
    AggregatorParams() {
    }

    /**
     * Сконструировать параметры аггрегатора, основанные на параметрах downtime и unreachable
     *
     * @param downtimesMode     как учитывать при аггрегации сигналы с хостов, по которым действует downtime
     * @param unreachableParams как учитывать при аггрегации сигналы с недоступных хостов
     * @see ParamsMode
     * @see UnreachableParams
     */
    AggregatorParams(ParamsMode downtimesMode, UnreachableParams unreachableParams) {
        withDowntimesMode(downtimesMode);
        withUnreachableParams(unreachableParams);
    }

    /**
     * Заменить параметры downtimes переданными
     *
     * @param downtimesMode как учитывать при аггрегации сигналы с хостов, по которым действует downtime
     * @return текущий экземпляр параметров аггрегатора
     * @see ParamsMode
     */
    AggregatorParams withDowntimesMode(ParamsMode downtimesMode) {
        checkNotNull(downtimesMode);
        this.downtimesMode = downtimesMode;
        return this;
    }

    /**
     * Заменить параметры unreachable переданными
     *
     * @param unreachableParams как учитывать при аггрегации сигналы с недоступных хостов
     * @return текущий экземпляр параметров аггрегатора
     * @see UnreachableParams
     */
    AggregatorParams withUnreachableParams(UnreachableParams unreachableParams) {
        checkNotNull(unreachableParams);
        this.unreachableParams = unreachableParams;
        return this;
    }
}
