package ru.yandex.direct.ansiblejuggler.model.aggregators;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Агррегатор "все исходные события должны быть OK".
 * Выбирает наиболее критичный статус. Т.е. если хоть один warning, то агрегат warning.
 * Если хоть один critical, то агрегат critical.
 *
 * @see JugglerAggregator
 * @see <a href="https://wiki.yandex-team.ru/sm/juggler/FAQ/#agg-plugin">Как работают модули агрегации?</a>
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@ParametersAreNonnullByDefault
public class AllChildrenShouldBeOk extends JugglerAggregator {
    public AllChildrenShouldBeOk() {
        super("logic_or");
    }
}
