package ru.yandex.direct.ansiblejuggler.model.aggregators;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Агррегатор "хотя бы одно из исходных событий должно быть OK".
 * Выбирает наименее критичный статус.
 * Т.е. если хоть одна проверка в OK, то агрегат будет OK; если все в WARN → то WARN, если все CRIT → то CRIT.
 *
 * @see JugglerAggregator
 * @see <a href="https://wiki.yandex-team.ru/sm/juggler/FAQ/#agg-plugin">Как работают модули агрегации?</a>
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@ParametersAreNonnullByDefault
public class AnyChildShouldBeOk extends JugglerAggregator {
    public AnyChildShouldBeOk() {
        super("logic_and");
    }
}
