package ru.yandex.direct.ansiblejuggler.model.aggregators;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Режимы для аггрегаторов
 */
@ParametersAreNonnullByDefault
public enum ParamsMode {
    /**
     * при аггрегации учитывать значение как "OK" вне зависимости от реального состояния
     */
    FORCE_OK,

    /**
     * пропускать дочернее значение при аггрегации
     */
    SKIP;

    @JsonValue
    @Override
    public String toString() {
        return super.toString().toLowerCase();
    }
}
