package ru.yandex.direct.ansiblejuggler.model.aggregators;

import java.util.LinkedHashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ansiblejuggler.model.checks.JugglerChild;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Параметры аггрегатора, отвечающие за:
 * <ul>
 * <li>какие исходные хосты считать недоступными</li>
 * <li>как учитывать сигналы с таких хостов при аггрегации</li>
 * </ul>
 *
 * @see ParamsMode
 * @see <a href="https://wiki.yandex-team.ru/sm/juggler/check-dependencies/">Зависимости между проверками</a>
 */
@ParametersAreNonnullByDefault
public class UnreachableParams {
    private static final class JugglerChildWrapper {
        @JsonProperty
        private final JugglerChild check;

        private JugglerChildWrapper(JugglerChild check) {
            this.check = check;
        }

    }

    @JsonProperty(value = "unreach_mode")
    private final ParamsMode unreachableMode;

    @JsonProperty(value = "unreach_service")
    private final Set<JugglerChildWrapper> unreachableService;

    /**
     * @param mode    как учитывать недоступные хосты при аггрегации
     * @param service какую проверку использовать для выявления "недоступности"
     */
    UnreachableParams(ParamsMode mode, JugglerChild service) {
        checkNotNull(mode, "mode cannot be null");
        checkNotNull(service, "service cannot be null");

        unreachableMode = mode;

        unreachableService = new LinkedHashSet<>();
        unreachableService.add(new JugglerChildWrapper(service));
    }
}
